/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.specifiques;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.jni.TraitementsSpecifiques;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatSpecifique;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class RecyclageCodePorteur {
    private static Logger log = Logger.getLogger(RecyclageCodePorteur.class);

    public static Resultat traitement(TraitementsSpecifiques traitementsSpecifiques) throws ExceptionTraitement {
        try {
            if (traitementsSpecifiques != null) {
                ResultatSpecifique resultatSpecifique = new ResultatSpecifique("Recyclage du code porteur");
                try {
                    traitementsSpecifiques.initialiseLibrairie();
                    traitementsSpecifiques.recyclageCodePorteur();
                    resultatSpecifique.setRetour("Carte recycl\u00e9e (0x00000000)");
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Traitement echoue : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatSpecifique.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                return resultatSpecifique;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(110, "L'interface des traitements sp\u00e9cifiques est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(110, "Une erreur inattendue est survenue");
        }
    }
}

